local assets=
{
	Asset("ANIM", "anim/firesword.zip"),
	Asset("ANIM", "anim/swap_firesword.zip"),
 Asset("IMAGE", "images/inventoryimages/firesword.tex"),
 Asset("ATLAS", "images/inventoryimages/firesword.xml"),
}

local function onfinished(inst)
    inst:Remove()
end


local function fireonattack(inst, attacker, target)
          local randomnumber = math.random()*100
     if attacker:HasTag("fire1") and attacker:HasTag("fire2") and attacker:HasTag("fire3") then
         if attacker.components.health and attacker.components.health:GetPercent() < 1 and not target:HasTag("wall") then
          attacker.components.health:DoDelta(5)
          end
          attacker.components.sanity:DoDelta(5)
          attacker.components.hunger:DoDelta(5)
            if randomnumber < 5 and target.components.health then
              target.components.health:DoDelta(-TUNING.NIGHTSWORD_DAMAGE * 10)
            end
     else

       if randomnumber < 10 then
            if target.components.health then
              target.components.health:DoDelta(-TUNING.NIGHTSWORD_DAMAGE * 3)
            end

         if target.components.burnable and not target.components.burnable:IsBurning() then
         if target.components.freezable and target.components.freezable:IsFrozen() then           
            target.components.freezable:Unfreeze()            
         else            
            target.components.burnable:Ignite()
         end   
         end

        if target.components.freezable then
        target.components.freezable:AddColdness(-1)
        if target.components.freezable:IsFrozen() then
            target.components.freezable:Unfreeze()            
        end
        end

        if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
        end

       if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
        if target.sg and target.sg.sg.states.hit then
            target.sg:GoToState("hit")
        end
       end

       attacker.SoundEmitter:PlaySound("dontstarve/wilson/fireball_explo")
      if attacker.components.health and attacker.components.health:GetPercent() < 1 and not target:HasTag("wall") then
        attacker.components.health:DoDelta(5)
       end
       attacker.components.sanity:DoDelta(5)
       attacker.components.hunger:DoDelta(5)
    end
   end
        if inst.components.finiteuses then
        inst.components.finiteuses:Use(1)
         end
end

-------------------------------------------------------------------------------------------

local function GetSpawnPoint(pt)

    local theta = math.random() * 2 * PI
    local radius = 20

	local offset = FindWalkableOffset(pt, theta, radius, 12, true)
	if offset then
		return pt+offset
	end
end

local function onuse(inst)
    local owner = inst.components.inventoryitem.owner
        for k = 0, 16 do
            local rad = math.random(3, 15)
            local angle = k*((4*3.14159265)/16)
            local pos = Vector3(owner.Transform:GetWorldPosition()) + Vector3(rad*math.cos(angle), 0, rad*math.sin(angle))
            GetSeasonManager():DoLightningStrike(pos)
        end

    local pt = Vector3(inst.Transform:GetWorldPosition())       
    local spawn_pt = GetSpawnPoint(pt)
    if spawn_pt then
           local krampuser = SpawnPrefab("krampuser")
        if krampuser then
            krampuser.Physics:Teleport(spawn_pt:Get())
            krampuser:FacePoint(pt)
            return krampuser
        end
        else
        local krampuser = SpawnPrefab("krampuser")
        krampuser.Transform:SetPosition(inst.Transform:GetWorldPosition())
    end
end
-------------------------------------------------------------------------------------------
local function onlight(inst, target)
    if inst.components.finiteuses then
        inst.components.finiteuses:Use(1)
    end
end

local function fireone(inst, owner)
    if owner:HasTag("fire1") and owner:HasTag("fire2") and owner:HasTag("fire3") then
    inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE * 1.5)
    else
    inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE)
    end
local player = GetPlayer()
     if player:HasTag("fire1") and player:HasTag("fire2") and player:HasTag("fire3") and player:HasTag("fire4") and player:HasTag("fire5") and not player:HasTag("hadcallkrampuser") then
     player:AddTag("hadcallkrampuser")
     onuse(inst)
     end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_firesword", "swap_nightmaresword")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")   
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
        owner:AddTag("fire1")
    inst.task = inst:DoPeriodicTask(0.5, function() fireone(inst, owner) end)

end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
inst.task:Cancel() inst.task = nil
        owner:RemoveTag("fire1")
    inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE)
   if inst.components.useableitem then
   inst.components.useableitem:StopUsingItem()
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("firesword")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour(1, 1, 1, 1)
    
    inst:AddTag("firesword")
   
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(500)
    inst.components.finiteuses:SetUses(500)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
   
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/firesword.xml"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE)
    inst.components.weapon:SetOnAttack(fireonattack)


    inst:AddComponent("lighter")
    inst.components.lighter:SetOnLightFn(onlight)

    return inst
end

return Prefab( "common/inventory/firesword", fn, assets)